/*
 * Decompiled with CFR 0.152.
 */
package com.yurtmod.block;

import com.yurtmod.dimension.TentDimension;
import com.yurtmod.dimension.TentTeleporter;
import com.yurtmod.init.Config;
import com.yurtmod.structure.StructureType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Teleporter;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class TileEntityTentDoor
extends TileEntity {
    private static final String KEY_STRUCTURE_TYPE = "StructureTypeOrdinal";
    private static final String S_OFFSET_X = "TentOffsetX";
    private static final String S_OFFSET_Z = "TentOffsetZ";
    private static final String S_PLAYER_X = "PlayerPrevX";
    private static final String S_PLAYER_Y = "PlayerPrevY";
    private static final String S_PLAYER_Z = "PlayerPrevZ";
    private static final String S_PREV_DIM = "PreviousPlayerDimension";
    private StructureType structure;
    private int offsetX;
    private int offsetZ;
    private double prevX;
    private double prevY;
    private double prevZ;
    private int prevDimID;
    private ItemStack tentStack;

    public TileEntityTentDoor() {
        if (this.structure == null) {
            this.setStructureType(StructureType.YURT_SMALL);
        }
    }

    public TileEntityTentDoor(StructureType type) {
        this.structure = type;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        int ordinal = nbt.func_74762_e(KEY_STRUCTURE_TYPE);
        this.structure = StructureType.values()[ordinal];
        this.offsetX = nbt.func_74762_e(S_OFFSET_X);
        this.offsetZ = nbt.func_74762_e(S_OFFSET_Z);
        this.prevX = nbt.func_74769_h(S_PLAYER_X);
        this.prevY = nbt.func_74769_h(S_PLAYER_Y);
        this.prevZ = nbt.func_74769_h(S_PLAYER_Z);
        this.prevDimID = nbt.func_74762_e(S_PREV_DIM);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a(KEY_STRUCTURE_TYPE, this.structure.ordinal());
        nbt.func_74768_a(S_OFFSET_X, this.offsetX);
        nbt.func_74768_a(S_OFFSET_Z, this.offsetZ);
        nbt.func_74780_a(S_PLAYER_X, this.prevX);
        nbt.func_74780_a(S_PLAYER_Y, this.prevY);
        nbt.func_74780_a(S_PLAYER_Z, this.prevZ);
        nbt.func_74768_a(S_PREV_DIM, this.getPrevDimension());
        return nbt;
    }

    public static final int getChunkOffsetX(int actualX) {
        return actualX / 16;
    }

    public static final int getChunkOffsetZ(int actualZ) {
        return actualZ / 16;
    }

    public void setStructureType(StructureType type) {
        this.structure = type;
    }

    public StructureType getStructureType() {
        return this.structure;
    }

    public void setOffsetX(int toSet) {
        this.offsetX = toSet;
    }

    public int getOffsetX() {
        return this.offsetX;
    }

    public void setOffsetZ(int toSet) {
        this.offsetZ = toSet;
    }

    public int getOffsetZ() {
        return this.offsetZ;
    }

    public void setOverworldXYZ(double posX, double posY, double posZ) {
        this.prevX = posX;
        this.prevY = posY;
        this.prevZ = posZ;
    }

    public void setPrevDimension(int dimID) {
        this.prevDimID = dimID;
    }

    public int getPrevDimension() {
        return this.prevDimID;
    }

    public BlockPos getXYZFromOffsets() {
        int x = this.offsetX * 16;
        int y = 71;
        int z = this.offsetZ * 16;
        return new BlockPos(x, y, z);
    }

    public boolean teleport(Entity entity) {
        int dimTo;
        entity.func_181015_d(this.func_174877_v());
        int dimFrom = entity.func_130014_f_().field_73011_w.getDimension();
        int n = dimTo = TentDimension.isTentDimension(dimFrom) ? this.getPrevDimension() : TentDimension.DIMENSION_ID;
        if (entity.field_71088_bW <= 0) {
            entity.field_71088_bW = 10;
            BlockPos corners = this.getXYZFromOffsets();
            MinecraftServer mcServer = entity.func_184102_h();
            WorldServer oldServer = mcServer.func_71218_a(dimFrom);
            WorldServer newServer = mcServer.func_71218_a(dimTo);
            TentTeleporter tel = new TentTeleporter(dimFrom, newServer, corners, this.prevX, this.prevY, this.prevZ, this.structure);
            if (entity instanceof EntityPlayerMP) {
                EntityPlayerMP playerMP = (EntityPlayerMP)entity;
                try {
                    ReflectionHelper.setPrivateValue(EntityPlayerMP.class, (Object)playerMP, (Object)true, (String[])new String[]{"field_184851_cj", "invulnerableDimensionChange"});
                }
                catch (ReflectionHelper.UnableToFindFieldException unableToFindFieldException) {
                    // empty catch block
                }
                mcServer.func_184103_al().transferPlayerToDimension(playerMP, dimTo, (Teleporter)tel);
            } else {
                mcServer.func_184103_al().transferEntityToWorld(entity, dimFrom, oldServer, newServer, (Teleporter)tel);
            }
            return true;
        }
        entity.field_71088_bW = 10;
        return false;
    }

    public boolean onEntityCollide(Entity entity, EnumFacing tentDir) {
        if (TileEntityTentDoor.canTeleportEntity(entity) && (entity instanceof EntityPlayer && Config.ALLOW_PLAYER_COLLIDE || !(entity instanceof EntityPlayer) && Config.ALLOW_NONPLAYER_COLLIDE)) {
            if (!TentDimension.isTentDimension(entity.func_130014_f_())) {
                BlockPos respawn = this.func_174877_v().func_177967_a(tentDir.func_176734_d(), 1);
                double posX = (double)respawn.func_177958_n() + 0.5;
                double posY = (double)respawn.func_177956_o() + 0.01;
                double posZ = (double)respawn.func_177952_p() + 0.5;
                this.setOverworldXYZ(posX, posY, posZ);
            }
            return this.teleport(entity);
        }
        return false;
    }

    public boolean onPlayerActivate(EntityPlayer player) {
        if (TileEntityTentDoor.canTeleportEntity((Entity)player)) {
            if (!TentDimension.isTentDimension(player.func_130014_f_())) {
                double posX = player.field_70165_t;
                double posY = player.field_70163_u;
                double posZ = player.field_70161_v;
                this.setOverworldXYZ(posX, posY, posZ);
            }
            return this.teleport((Entity)player);
        }
        return false;
    }

    public static boolean canTeleportEntity(Entity entity) {
        boolean ridingFlag = entity.func_184218_aH() || entity.func_184207_aI();
        boolean isInvalidClass = entity instanceof EntityEnderman;
        return !ridingFlag && !isInvalidClass && entity.func_184222_aU();
    }
}

